/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import dev.engine_room.flywheel.lib.model.baked.BlockModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.ChunkLayerSortedListBuilder;
import dev.engine_room.flywheel.lib.model.baked.MeshHelper;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public final class FabricBlockModelBuilder
extends BlockModelBuilder {
    public FabricBlockModelBuilder(class_1920 level, Iterable<class_2338> positions) {
        super(level, positions);
    }

    @Override
    public FabricBlockModelBuilder poseStack(@Nullable class_4587 poseStack) {
        super.poseStack(poseStack);
        return this;
    }

    @Override
    public FabricBlockModelBuilder renderFluids(boolean renderFluids) {
        super.renderFluids(renderFluids);
        return this;
    }

    @Override
    public FabricBlockModelBuilder materialFunc(@Nullable BiFunction<class_1921, Boolean, Material> materialFunc) {
        super.materialFunc(materialFunc);
        return this;
    }

    @Override
    public SimpleModel build() {
        if (this.materialFunc == null) {
            this.materialFunc = ModelUtil::getMaterial;
        }
        ChunkLayerSortedListBuilder builder = ChunkLayerSortedListBuilder.getThreadLocal();
        BakedModelBufferer.bufferBlocks(this.positions.iterator(), this.level, this.poseStack, this.renderFluids, (renderType, shaded, data) -> {
            Material material = (Material)this.materialFunc.apply(renderType, shaded);
            if (material != null) {
                SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=BlockModelBuilder,renderType=" + renderType + ",shaded=" + shaded);
                builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder.build());
    }
}

